<?php
/**
* Set the content width based on the theme's design and stylesheet.
*/
if ( ! defined( 'MANUAL_THEME_VERSION' ) ) {
define( 'MANUAL_THEME_VERSION', '7.5.4' );
}

if ( ! isset( $content_width ) ) $content_width = 700;

/*-----------------------------------------------------------------------------------*/
/*	Sets up theme defaults and registers support for various WordPress features.
/*-----------------------------------------------------------------------------------*/
if ( ! function_exists( 'manual_theme_manual_setup' ) ) {
	function manual_theme_manual_setup() {
		
        /*	Load Text Domain */
		load_theme_textdomain( 'manual', trailingslashit( get_template_directory() ) . 'languages' );
		
        /*	Add Automatic Feed Links Support */
        add_theme_support( 'automatic-feed-links' );
		
        /* Add Post Formats Support */
		add_theme_support('post-formats', array('link', 'aside', 'gallery', 'image', 'quote', 'status', 'video', 'audio', 'chat'));
		
		/*
		 * Switch default core markup for search form, comment form, and comments
		 * to output valid HTML5.
		 */
		add_theme_support(
			'html5',
			array(
				'comment-form',
				'comment-list',
				'gallery',
				'caption',
				'style',
				'script',
				'navigation-widgets',
			)
		);
		
		/* Add WooCommerce support */
		add_theme_support( 'woocommerce' );
		
		/*** If BBPress is active, add theme support */
		if ( class_exists( 'bbPress' ) ) { add_theme_support( 'bbpress' ); }

		/* Let WordPress manage the document title. */
		add_theme_support( 'title-tag' );
		
		/* Add Post Thumbnails Support and Related Image Sizes */
		add_theme_support( 'post-thumbnails' );
		set_post_thumbnail_size( 825, 510, true );
		
		/** This theme uses wp_nav_menu() in one location. */
		register_nav_menus( array(
			'primary' => esc_html__( 'Primary Menu',  'manual' ),
			'footer'  => esc_html__( 'Footer Menu',  'manual' ),
		) );
		
		/** Custom image sizes */
		add_image_size( 'portfolio-FitRows', 700, 525, true ); 
		
		// Add support for responsive embedded content.
		add_theme_support( 'responsive-embeds' );
		
		// Add support for Block Styles.
		add_theme_support( 'wp-block-styles' );

		// Add support for editor styles.
		add_theme_support( 'editor-styles' );

		// Enqueue editor styles.
		add_editor_style( 'css/style-editor.css' );

		// Add support for full and wide align images.
		add_theme_support( 'align-wide' );
		
	}
}
add_action( 'after_setup_theme', 'manual_theme_manual_setup' );

/*-----------------------------------------------------------------------------------*/
/*	Framework :: REDUXCORE (Manual Theme Options)
/*-----------------------------------------------------------------------------------*/
require_once( trailingslashit( get_template_directory() ) . 'framework/ReduxCore/manual/manual.php' );
require_once( trailingslashit( get_template_directory() ) . 'framework/ReduxCore/manual/metaboxes.php' );

/*-----------------------------------------------------------------------------------*/
/*	Framework :: CMB2 (META TYPE)
/*-----------------------------------------------------------------------------------*/ 
require trailingslashit( get_template_directory() ) . 'framework/post-meta/kb.php';
require trailingslashit( get_template_directory() ) . 'framework/post-meta/portfolio.php';
require trailingslashit( get_template_directory() ) . 'framework/post-meta/custom-meta.php';
require trailingslashit( get_template_directory() ) . 'framework/post-meta/doc.php';
require trailingslashit( get_template_directory() ) . 'framework/post-meta/faq.php';

/*-----------------------------------------------------------------------------------*/
/*	Customizer
/*-----------------------------------------------------------------------------------*/ 
require trailingslashit( get_template_directory() ) . 'framework/customize/temp-logo.php';
require trailingslashit( get_template_directory() ) . 'framework/customize/temp-main-header.php';
require trailingslashit( get_template_directory() ) . 'framework/customize/temp-header-title-bar.php';
require trailingslashit( get_template_directory() ) . 'framework/customize/temp-header-title-bar-control.php';
require trailingslashit( get_template_directory() ) . 'framework/customize/temp-footer.php';
require trailingslashit( get_template_directory() ) . 'framework/customize/temp-login.php';
require trailingslashit( get_template_directory() ) . 'framework/customizer.php';
require trailingslashit( get_template_directory() ) . 'framework/customize/customize.php';
require trailingslashit( get_template_directory() ) . 'framework/customize/lib/main-header.php';
require trailingslashit( get_template_directory() ) . 'framework/customize/lib/header-title-bar.php';
require trailingslashit( get_template_directory() ) . 'framework/customize/lib/menu.php';
require trailingslashit( get_template_directory() ) . 'framework/customize/lib/layout.php';
require trailingslashit( get_template_directory() ) . 'framework/customize/lib/colors.php';
require trailingslashit( get_template_directory() ) . 'framework/customize/lib/typography.php';
require trailingslashit( get_template_directory() ) . 'framework/customize/lib/wedocs.php';
require trailingslashit( get_template_directory() ) . 'framework/customize/lib/header-title-bar-post-type.php';
require trailingslashit( get_template_directory() ) . 'framework/customize/lib/search-box.php';
require trailingslashit( get_template_directory() ) . 'framework/customize/lib/knowledgebase.php';
require trailingslashit( get_template_directory() ) . 'template/search/functions.php';
require trailingslashit( get_template_directory() ) . 'template/bbpress/functions.php';

/*-----------------------------------------------------------------------------------*/
/*	Custom template tags for this theme
/*-----------------------------------------------------------------------------------*/ 
require trailingslashit( get_template_directory() ) . 'framework/template-tags.php';

/*-----------------------------------------------------------------------------------*/
/*	Widget Register & Placement
/*-----------------------------------------------------------------------------------*/ 
require trailingslashit( get_template_directory() ) . 'framework/widget/widget-type.php';
require trailingslashit( get_template_directory() ) . 'framework/widget/widget.php';

/*-----------------------------------------------------------------------------------*/
/*	Breadcrumb
/*-----------------------------------------------------------------------------------*/ 
require trailingslashit( get_template_directory() ) . 'framework/breadcrumb.php';

/*-----------------------------------------------------------------------------------*/
/*	DOC + KB + FAQ
/*-----------------------------------------------------------------------------------*/ 
require trailingslashit( get_template_directory() ) . 'template/doc/functions.php';
require trailingslashit( get_template_directory() ) . 'template/doc/doc-ajax.php';
require trailingslashit( get_template_directory() ) . 'template/kb/functions.php';
require trailingslashit( get_template_directory() ) . 'framework/post-type-category/cat.php'; 
require trailingslashit( get_template_directory() ) . 'template/faq/functions.php';

/*-----------------------------------------------------------------------------------*/
/*	SUPPORT FUNCTION
/*-----------------------------------------------------------------------------------*/ 
require trailingslashit( get_template_directory() ) . 'framework/includes/functions.php';
require_once( trailingslashit( get_template_directory() ) . 'framework/ReduxCore/manual/default.php' );

/*-----------------------------------------------------------------------------------*/
/*	HOOK
/*-----------------------------------------------------------------------------------*/
require trailingslashit( get_template_directory() ) . 'framework/includes/hook.php';

/*-----------------------------------------------------------------------------------*/
/*	Custom Menu
/*-----------------------------------------------------------------------------------*/  
require trailingslashit( get_template_directory() ) . 'framework/includes/menu.php';

/*-----------------------------------------------------------------------------------*/
/*	WOOCOMMERCE
/*-----------------------------------------------------------------------------------*/
require trailingslashit( get_template_directory() ) . 'woocommerce/woocommerce_configuration.php';

/*-----------------------------------------------------------------------------------*/
/*	LEARNPRESS
/*-----------------------------------------------------------------------------------*/ 
require trailingslashit( get_template_directory() ) . 'framework/learnpress/class_learnpress.php';

/*-----------------------------------------------------------------------------------*/
/*	ELEMENTOR
/*-----------------------------------------------------------------------------------*/ 
if ( manual__abs_plugin_active( 'elementor/elementor.php' ) ) {
	require trailingslashit( get_template_directory() ) . 'elementor/addons.php';
}

/*-----------------------------------------------------------------------------------*/
/*	WEDOC
/*-----------------------------------------------------------------------------------*/ 
$is_plugin_wedocs_active = manual__plugin_active('WeDocs');
if ( $is_plugin_wedocs_active == true ) {
	require trailingslashit( get_template_directory() ) . 'wedocs/wedocs.php';
}

/*-----------------------------------------------------------------------------------*/
/*	ACTIVATE VC
/*-----------------------------------------------------------------------------------*/
$is_plugin_js_composer_active = manual__plugin_active('Vc_Manager');
if ( $is_plugin_js_composer_active == true ) {
	require trailingslashit( get_template_directory() ) . 'framework/vc-include/row.php';
	require trailingslashit( get_template_directory() ) . 'framework/vc-include/vc.php';
	require trailingslashit( get_template_directory() ) . 'framework/vc-include/shortcodes.php';
	require trailingslashit( get_template_directory() ) . 'framework/vc-include/template.php';
}
?>