<?php 
// AJAX pagination for custom post type
add_action('wp_ajax_manual__faq_catpg_load_posts', 'manual__faq_catpg_load_posts');
add_action('wp_ajax_nopriv_manual__faq_catpg_load_posts', 'manual__faq_catpg_load_posts');

function manual__faq_catpg_load_posts() {
	ob_start();
	global $theme_options;
	
	$max_page = $_POST['total_page_break'];
	$current_page = $_POST['current_display_page'];
	$term_slug = $_POST['terms'];
	
	if( isset($theme_options['faq-display-order']) && $theme_options['faq-display-order'] != ''  ) {
		if( $theme_options['faq-display-order'] == 1 ) {
			$faq_record_order = 'ASC';
		} else {
			$faq_record_order = 'DESC';
		}
	}
	
	if( isset( $theme_options['faq-display-order-by'] ) && $theme_options['faq-display-order-by'] != '' ) {
		$faq_record_order_by = $theme_options['faq-display-order-by'];	
	} else {
		$faq_record_order_by = 'date';	
	}
  
  
	$page = isset($_POST['page']) ? intval($_POST['page']) : 1;

	$args = array(
		'post_type' => 'manual_faq',
		'paged' => $current_page,
		'posts_per_page' => (isset($theme_options['faq-noof-records-catper-page'])?$theme_options['faq-noof-records-catper-page']:'-1'),
		'order'    => $faq_record_order,
		'orderby'  => $faq_record_order_by,
		'tax_query' => array(
				array(
					'taxonomy' => 'manualfaqcategory',
					'field' => 'slug',
					'include_children' => true,
					'terms' => $term_slug
					)
				),
		
	);
	
	$wp_query_data = new WP_Query($args);
	if($wp_query_data->have_posts()) { 
		while($wp_query_data->have_posts()) :  $wp_query_data->the_post(); 
		$postID = get_the_ID();
		?>
		
		<div class="collapsible-panels theme-faq-cat-pg faq-catpg-<?php echo esc_attr($postID); ?>" id="<?php echo esc_attr($postID); ?>">
		  <h5 class="title-faq-cat" <?php echo esc_attr($overwrite_css); ?>><a href="#"><?php echo esc_html(get_the_title()); ?></a></h5>
		  <span class="faq-postlink" onclick="prompt('<?php echo esc_html__( 'Press Ctrl + C, then Enter to copy to clipboard', 'manual' ) ?>','<?php echo get_permalink().'#'.$postID ?>')"><?php echo esc_html__( '#', 'manual' ) ?></span>
		</div>
		<div class="entry-content clearfix entry-content-<?php echo esc_attr($postID); ?> entry-content-faq-all display-none">
			<?php the_content(); ?>
			<?php edit_post_link( esc_html__( 'Edit', 'manual' ), '<p class="post-edit-link" style="text-align:right"><i class="fa fa-edit"></i> ', '</p>', $postID ); ?>
			<?php if( $theme_options['faq-display-social-share'] == true ) manual_social_share(get_permalink()); ?>
	   </div>
	   
	<?php 
		endwhile;  
	}
	wp_reset_postdata();
	wp_die();
}
?>