<?php 
/**
 * @author     SmartWpThemes
 * @copyright  (c) Copyright by SmartWpThemes
 * @link       https://smartwpthemes.com/
 * @package    Manual
 * @since      5.0
 */
 
// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}
?>
<div class="wp-header-end"></div>

<div class="manual-theme-admin-header-wrap">

	<div class="theme-admin-page-intro">
		<div class="container page-container">
			<div class="details">
				<h1><?php _e( 'Demo Import', 'manual-framework' ); ?></h1>
			</div>
		</div>
	</div>
   	<?php settings_errors(); ?>
    
	<div class="container page-container">
		<div id="tabs" class="manual-theme-nav">
			<ul class="manual-theme-block-layout manual-theme-nav-inner">
				<li><a href="#tabs-1" class="selected"><?php _e( 'Import Demo Data', 'manual-framework' ); ?></a></li>
				<li><a href="#tabs-2" ><?php _e( 'System Status', 'manual-framework' ); ?></a></li>
			</ul>
            
			<div class="tab-item" id="tabs-1">
            	<?php 
				$license = explode("%", get_option( 'manual_license', false ));
				if ( isset($license[0]) && $license[0] != '' ) { 
				if ( class_exists('OCDI_Plugin') ) { ?>
				<h3><?php _e( 'Getting Started', 'manual-framework' ); ?></h3>

				<div class="manual-theme-admin-body-group-sidebar-layout">
					<div class="col">
						<!-- Group 1 -->
						<div class="manual-theme-admin-body-group">
							<div class="manual-theme-admin-body-group-headline">
								<h3><?php _e( 'About', 'manual-framework' ); ?></h3>
								<a href="https://smartwpthemes.com/documentation/manual/" target="_blank" class="btn btn-outline"><?php _e( 'View Docs', 'manual-framework' ); ?></a>
							</div>
							<div class="manual-theme-admin-body-group-details">
								<?php _e( 'When you import the demo data, the following actions will occur:', 'manual-framework' ); ?>
							</div>
							<div class="manual-theme-admin-body-group-content">
								<?php esc_html_e( 'The demo content, including posts, custom post types, pages, categories, tags, media files, local page settings, and Theme Settings, will be imported. (No changes will be made to existing data such as posts, pages, categories, tags, media files, etc.)', 'manual-framework' ); ?>
							</div>
						</div>
					</div>
					<div class="col">
						<!-- Group 2 -->
						<div class="manual-theme-admin-body-group manual-theme-admin-body-group-warning">
							<div class="manual-theme-admin-body-group-headline">
								<h3><svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24"><path d="M12 5.177l8.631 15.823h-17.262l8.631-15.823zm0-4.177l-12 22h24l-12-22zm-1 9h2v6h-2v-6zm1 9.75c-.689 0-1.25-.56-1.25-1.25s.561-1.25 1.25-1.25 1.25.56 1.25 1.25-.561 1.25-1.25 1.25z"/></svg> <?php _e( 'Heads up!', 'manual-framework' ); ?></h3>
							</div>
							<div class="manual-theme-admin-body-group-details">
								<?php esc_html_e( 'Theme Settings are replaced with each import.', 'manual-framework' ); ?> 
								<p>
								<strong><?php esc_html_e( 'IMPORTANT', 'manual-framework' ); ?></strong></br><hr>
								<?php esc_html_e( 'To set up the site demo with "WPBakery Page Builder," please ensure that you\'ve installed and activated the "WPBakery Page Builder" plugin before beginning the import process.', 'manual-framework' ); ?> 
								</p>
							</div>
						</div>
					</div>
				</div>
                <?php }} ?>
				<?php include 'parts/import-demo.php'; ?>
			</div>
			<div class="tab-item" id="tabs-2" style="display: none;">
				<?php include 'parts/system-status-section.php'; ?>
			</div>
		</div>
	</div>
    
</div>