<?php 
/* 
 * Plugin Name:   Manual Framework (Post Type) 
 * Version:       5.0.7
 * Plugin URI:    https://smartwpthemes.com/
 * Description:   <strong>Support MANUAL wordpress theme</strong>.
 * Author:        pixelacehq (Jabin Kadel)
 * Author URI:    https://smartwpthemes.com/
 *
 * License: Copyright (c) SmartWpThemes.com. All rights reserved.
 *  
 */

$manual_framework_get_theme = wp_get_theme();
if ( strtolower( $manual_framework_get_theme->template ) == 'manual' ) {

		function check_child_theme_active() {
			$template_dir = get_template_directory();
			$stylesheet_dir = get_stylesheet_directory();
			return $stylesheet_dir !== $template_dir;
		}
		
		//check manual theme version
		if( check_child_theme_active() ) { 
			if( $manual_framework_get_theme->parent()->version < '7.5.2') {
				add_action( 'admin_notices', 'manual_framework__notice' );
			}
		} else { 
			if( ($manual_framework_get_theme->version < '7.5.2') ) {
				add_action( 'admin_notices', 'manual_framework__notice' );
			}
		}

		define( 'MANUALSUPPORT_PLUGIN', __FILE__ );
		define( 'MANUALSUPPORT_PLUGIN_VERSION', '5.0.7' );
		define( 'MANUALSUPPORT_PLUGIN_DIR', untrailingslashit( dirname( MANUALSUPPORT_PLUGIN ) ) );
		
		/********************************
		*** ACTIVATE PLUGIN ACTION  ***
		***********************************/
		$manual_framework_path     = preg_replace('/^.*wp-content[\\\\\/]plugins[\\\\\/]/', '', __FILE__);
		$manual_framework_path     = str_replace('\\','/',$manual_framework_path);
		
		// Langauge Support
		add_action('plugins_loaded', 'manual_framework_load_textdomain');
		function manual_framework_load_textdomain() {
				load_plugin_textdomain( 'manual-framework', false, plugin_basename( dirname( __FILE__ ) ) . '/languages/' );
		}
		
		// Version Upgrade
		add_action('activate_'.$manual_framework_path, 'manual_framework_plugin_active'); 
		function manual_framework_plugin_active() {
			update_option( 'manual_theme_framework_version', MANUALSUPPORT_PLUGIN_VERSION );
			manual_framework__wp_permalink();
			return true;
		}
		
		// Styles and JS scripts
		function manual_framework_admin_style_and_scripts() {
			wp_enqueue_style( 'manual-framework-styles', plugin_dir_url( __FILE__ ) . 'assets/css/manual-framework.css' );
			wp_enqueue_script( 'manual-framework-scripts', plugin_dir_url( __FILE__ ) . 'assets/js/manual-framework.js', [], '1.1' );
			wp_enqueue_script( 'manual-framework-license', plugin_dir_url( __FILE__ ) . 'assets/js/manual-active.js', [], '1.1' );
		}
		add_action( 'admin_enqueue_scripts', 'manual_framework_admin_style_and_scripts' );
		
		function manual_framework_frontend_style_and_scripts() {
			wp_register_script('printomatic-js', plugin_dir_url( __FILE__ ) . 'assets/js/print/printomat.js', array('jquery'), '1.1', true);
			wp_register_script('pe-js', plugin_dir_url( __FILE__ ) . 'assets/js/print/print_elements.js', array('printomatic-js'), '1.1', true);
			$print_data = [
				'pom_html_top' => '',
				'pom_html_bottom' => '',
				'pom_do_not_print' => '',
				'pom_pause_time' => '',
			];
			wp_add_inline_script( 'printomatic-js', 'var print_data = ' . json_encode( $print_data ), 'before' );
			wp_enqueue_style( 'printomatic-css', plugin_dir_url( __FILE__ ) . 'assets/css/print/style.css' );
		}
		add_action('wp_enqueue_scripts', 'manual_framework_frontend_style_and_scripts' );
		
		// Demo Import
		require MANUALSUPPORT_PLUGIN_DIR . '/import/import_location.php';
		require MANUALSUPPORT_PLUGIN_DIR . '/import/import_files.php';
		require MANUALSUPPORT_PLUGIN_DIR . '/import/import_before.php';
		require MANUALSUPPORT_PLUGIN_DIR . '/import/import_after.php';
		require MANUALSUPPORT_PLUGIN_DIR . '/import/import_required.php';
		// Post Type
		require MANUALSUPPORT_PLUGIN_DIR . '/post-type/knowledgebase.php';
		require MANUALSUPPORT_PLUGIN_DIR . '/post-type/documentation.php';
		require MANUALSUPPORT_PLUGIN_DIR . '/post-type/faq.php';
		require MANUALSUPPORT_PLUGIN_DIR . '/post-type/portfolio.php';
		require MANUALSUPPORT_PLUGIN_DIR . '/post-type/custom-hook.php';
		//Adv. Settings
		require MANUALSUPPORT_PLUGIN_DIR . '/inc/adv-settings.php';
		require MANUALSUPPORT_PLUGIN_DIR . '/inc/functions.php';
		// Widget
		require MANUALSUPPORT_PLUGIN_DIR . '/widget/widget-social.php';
		require MANUALSUPPORT_PLUGIN_DIR . '/widget/widget-button.php';
		require MANUALSUPPORT_PLUGIN_DIR . '/widget/widget-woo.php';
		// Print
		require MANUALSUPPORT_PLUGIN_DIR . '/inc/print.php';
		if(is_admin()) { 
			require MANUALSUPPORT_PLUGIN_DIR . '/admin/admin.php'; 
			require MANUALSUPPORT_PLUGIN_DIR . '/announcement/main.php'; 
		}
		
} else {
	add_action( 'admin_notices', 'manual_framework_admin_notice' );
	function manual_framework_admin_notice() {
?>
	<div class="notice notice-error is-dismissible">
		<p>
			<strong><?php esc_html_e( 'This theme does not support the \'Manual Framework\' plugin', 'manual-framework' ); ?></strong>
			<br>
			<?php esc_html_e( 'Please activate this plugin only when using the Manual theme, or deactivate it.', 'manual-framework' ); ?>
		</p>
	</div>
<?php
	}
}
?>