<?php
/**
 * @author     SmartWpThemes
 * @copyright  (c) Copyright by SmartWpThemes
 * @link       https://smartwpthemes.com/
 * @package    Manual
 * @since      5.0
 */
 
// Do not allow directly accessing this file.
if ( ! defined( 'ABSPATH' ) ) {
	exit( 'Direct script access denied.' );
}

/********************
*** DOCUMENTATION ***
*********************/
add_action( 'init', 'manual_documentation_post_type' );
if ( ! function_exists( 'manual_documentation_post_type' ) ) {

	
	function manual_documentation_post_type() {
		
		global $theme_options;
		
		if( isset($theme_options['doc-slug-name']) && $theme_options['doc-slug-name'] != ''  ) {
			$new_slug_name = $theme_options['doc-slug-name'];
		} else {
			$new_slug_name = 'documentation';
		}
		
		if( isset($theme_options['doc-breadcrumb-name']) && $theme_options['doc-breadcrumb-name'] != ''  ) {
			$doc_breadcrumb_name = $theme_options['doc-breadcrumb-name'];
		} else {
			$doc_breadcrumb_name = 'Documentation';
		}
		
		if( isset($theme_options['documentation-comment-status']) && $theme_options['documentation-comment-status'] == true ) {
			$activate_comment = 'comments';
		} else {
			$activate_comment = '';
		}
		
		if( isset($theme_options['doc-gutenberg-editor-onoff']) && $theme_options['doc-gutenberg-editor-onoff'] == true ) {
			$doc_gutenberg_editor = true;
		} else {
			$doc_gutenberg_editor = false;
		}
		
		if( isset($theme_options['doc-post-type-support-custom-fields']) && $theme_options['doc-post-type-support-custom-fields'] == true ) {
			$custom_fields = 'custom-fields';
		} else {
			$custom_fields = '';
		}
		
	
		register_post_type('manual_documentation',
			array(
			'labels' => array(
					'name' => esc_html__( 'Documentation', 'manual-framework' ),
					'singular_name' => sprintf( esc_html( _x('%s', 'Documentation', 'manual-framework') ), $doc_breadcrumb_name),
					'add_new' => esc_html__('Add Documentation', 'manual-framework'),  
					'add_new_item' => esc_html__('Add New Documentation', 'manual-framework'),  
					'edit_item' => esc_html__('Edit Documentation', 'manual-framework'),  
					'new_item' => esc_html__('New Documentation', 'manual-framework'),  
					'view_item' => esc_html__('View Documentation', 'manual-framework'),  
					'search_items' => esc_html__('Search Documentation', 'manual-framework'),  
					'not_found' =>  esc_html__('No Documentation found', 'manual-framework'),  
					'not_found_in_trash' => esc_html__('No Documentation found in Trash', 'manual-framework'),
					
					'menu_name'           => esc_html__( 'Documentation', 'manual-framework' ),
					'parent_item_colon'   => esc_html__( 'Parent Documentation:', 'manual-framework' ),
					'all_items'           => esc_html__( 'All Documentation', 'manual-framework' ),
					'update_item'         => esc_html__( 'Update Documentation', 'manual-framework' ),
				),
				
			'taxonomies'  => array( 'manualdocumentationcategory' ),	
			'public' => true,
			'menu_position' => 5,
			
			'rewrite' => array(	'slug' => $new_slug_name,
								'with_front' => false),
								
			'supports' => array(
				'title',
				'author',
				'editor',
				'revisions',
				'page-attributes','thumbnail', $activate_comment, $custom_fields),
				
			'public' => true,
			'show_ui' => true,
			'publicly_queryable' => true,
			'capability_type' => 'page',
			'hierarchical' => true,
			'exclude_from_search' => false,
			'show_in_nav_menus'  => true,
			'query_var'          => true,
			'show_in_admin_bar'   => true,
			'can_export'          => true,
			'menu_icon'           => plugin_dir_url( __FILE__ ) . 'img/doc.png',
			'show_in_rest'        => $doc_gutenberg_editor,
			)
		);
		
	}
	
}

if ( ! function_exists('manual_documentation_category_taxonomy') ) {
// Register faq Category Custom Taxonomy
function manual_documentation_category_taxonomy()  {
	
	global $theme_options;
	
	if( isset($theme_options['doc-cat-slug-name']) && $theme_options['doc-cat-slug-name'] != ''  ) {
		$new_cat_slug_name = $theme_options['doc-cat-slug-name'];
	} else {
		$new_cat_slug_name = 'doc';
	}
	
	if( isset($theme_options['doc-gutenberg-editor-onoff']) && $theme_options['doc-gutenberg-editor-onoff'] == true ) {
		$doc_gutenberg_editor = true;
	} else {
		$doc_gutenberg_editor = false;
	}
	

	$labels = array(
		'name'                       => esc_html__( 'Documentation Categories', 'manual-framework' ),
		'singular_name'              => esc_html__( 'Documentation Category', 'manual-framework' ),
		'menu_name'                  => esc_html__( 'Documentation Categories', 'manual-framework' ),
		'all_items'                  => esc_html__( 'All Categories', 'manual-framework' ),
		'parent_item'                => esc_html__( 'Parent Category', 'manual-framework' ),
		'parent_item_colon'          => esc_html__( 'Parent Category:', 'manual-framework' ),
		'new_item_name'              => esc_html__( 'New Category Name', 'manual-framework' ),
		'add_new_item'               => esc_html__( 'Add New Category', 'manual-framework' ),
		'edit_item'                  => esc_html__( 'Edit Category', 'manual-framework' ),
		'update_item'                => esc_html__( 'Update Category', 'manual-framework' ),
		'separate_items_with_commas' => esc_html__( 'Separate categories with commas', 'manual-framework' ),
		'search_items'               => esc_html__( 'Search categories', 'manual-framework' ),
		'add_or_remove_items'        => esc_html__( 'Add or remove categories', 'manual-framework' ),
		'choose_from_most_used'      => esc_html__( 'Choose from the most used categories', 'manual-framework' ),
	);

	$rewrite = array(
		'slug'                       => $new_cat_slug_name,
		'with_front'                 => false,
		'hierarchical'               => true,
	);

	$args = array(
		'labels'                     => $labels,
		'hierarchical'               => true,
		'public'                     => true,
		'show_ui'                    => true,
		'show_admin_column'          => true,
		'show_in_nav_menus'          => true,
		'show_tagcloud'              => false,
		'query_var'                  => true,
		'rewrite'                    => $rewrite,
		'show_in_rest'               => $doc_gutenberg_editor,
	);

	register_taxonomy( 'manualdocumentationcategory', 'manual_documentation', $args );
	flush_rewrite_rules();
}
// Hook into the 'init' action
add_action( 'init', 'manual_documentation_category_taxonomy', 0 );
}


if ( ! function_exists('manual_doc_tag_taxonomy') ) {

// Register Article Tag Custom Taxonomy
function manual_doc_tag_taxonomy()  {
	
	global $theme_options;
	
	if( isset($theme_options['doc-tag-slug-name']) && $theme_options['doc-tag-slug-name'] != ''  ) {
		$doc_tag_slug_name = $theme_options['doc-tag-slug-name'];
	} else {
		$doc_tag_slug_name = 'doc-tag';
	}
	
	if( isset($theme_options['doc-gutenberg-editor-onoff']) && $theme_options['doc-gutenberg-editor-onoff'] == true ) {
		$doc_gutenberg_editor = true;
	} else {
		$doc_gutenberg_editor = false;
	}
	
	$labels = array(
		'name'                       => esc_html__( 'Documentation Tags', 'manual-framework' ),
		'singular_name'              => esc_html__( 'Documentation Tag', 'manual-framework' ),
		'menu_name'                  => esc_html__( 'Documentation Tags', 'manual-framework' ),
		'all_items'                  => esc_html__( 'All Tags', 'manual-framework' ),
		'parent_item'                => esc_html__( 'Parent Tag', 'manual-framework' ),
		'parent_item_colon'          => esc_html__( 'Parent Tag:', 'manual-framework' ),
		'new_item_name'              => esc_html__( 'New Tag Name', 'manual-framework' ),
		'add_new_item'               => esc_html__( 'Add New Tag', 'manual-framework' ),
		'edit_item'                  => esc_html__( 'Edit Tag', 'manual-framework' ),
		'update_item'                => esc_html__( 'Update Tag', 'manual-framework' ),
		'separate_items_with_commas' => esc_html__( 'Separate tags with commas', 'manual-framework' ),
		'search_items'               => esc_html__( 'Search tags', 'manual-framework' ),
		'add_or_remove_items'        => esc_html__( 'Add or remove tags', 'manual-framework' ),
		'choose_from_most_used'      => esc_html__( 'Choose from the most used tags', 'manual-framework' ),
	);

	$rewrite = array(
		'slug'                       => $doc_tag_slug_name,
		'with_front'                 => false,
		'hierarchical'               => false,
	);

	$args = array(
		'labels'                     => $labels,
		'hierarchical'               => false,
		'public'                     => true,
		'show_ui'                    => true,
		'show_admin_column'          => true,
		'show_in_nav_menus'          => true,
		'show_tagcloud'              => true,
		'query_var'                  => true,
		'rewrite'                    => $rewrite,
		'show_in_rest'               => $doc_gutenberg_editor,
	);
	register_taxonomy( 'manual_doc_tag', 'manual_documentation', $args );
	flush_rewrite_rules();
}

// Hook into the 'init' action
add_action( 'init', 'manual_doc_tag_taxonomy', 0 );

}
?>