<?php 
get_header();

// sidebar status
if( $theme_options['faq-display-sidebar-status'] == true ) {
	$col_md_sm = 12;
	$sidebar_status = true;
} else {
	if( $theme_options['faq-sidebar-display-position'] == 'left' ) {
		$sidebar_position = 'left';
	} else {
		$sidebar_position = 'right';
	}
	$col_md_sm = 8;
	if( $theme_options['theme_widget_width_size_global'] == 1 ) {
		$col_md_sm = 9;
	}
	$sidebar_status = false;
}

// Get our extra meta
$st_term_data =	$wp_query->queried_object;
$term_slug = get_query_var( 'term' );
$current_term = get_term_by( 'slug', $term_slug, 'manualfaqcategory' );
$check_if_login_call = get_option( 'doc_cat_check_login_'.$current_term->term_id );
$check_user_role = get_option( 'doc_cat_user_role_'.$current_term->term_id );
$custom_login_message = get_option( 'doc_cat_login_message_'.$current_term->term_id );
?>
<!-- /start container -->
<div class="container content-wrapper body-content">
<div class="row margin-top-btm-50">

<?php if( $sidebar_status == false && $sidebar_position == 'left' ) get_template_part('sidebar', 'faq');  ?>

<?php
/*******************************
**** CATEGORY ACCESS CONTROL ****
********************************/
if( $check_if_login_call == 1 && !is_user_logged_in() ) { 
	echo '<div class="col-md-'.esc_html($col_md_sm).' col-sm-12">';
	manual__default_login_form($custom_login_message);
	echo '</div>';
} else { 

	/****************************************************
	**** LOGIN LEVEL (SUFFICIENT ACCESS LEVEL) CHECK ****
	*****************************************************/
	$access_status = manual_doc_access($check_user_role);
	if( $access_status == false ) { 
		echo '<div class="col-md-'.esc_html($col_md_sm).' col-sm-12"><div class="doc_access_control"><p>';
		echo esc_attr($theme_options['faq-cat-page-access-control-message']);
		echo '</p></div></div>';
	} else {
		
		/************************
		**** ARTICLE SECTION ****
		*************************/
?> 

<div class="col-md-<?php echo esc_html($col_md_sm); ?> col-sm-12">
  <?php if( $theme_options['faq-ed-expandcollapse'] == true ) { ?>
  <div class="margin-btm-20"> 
  <span><a class="more-link" id="faq-expandall" style="cursor:pointer;">
    <?php echo esc_attr($theme_options['faq-expand-collapse-text']); ?>
  </a></span> 
  </div>
  <?php } ?>
  <?php 
    if ( is_active_sidebar( 'faq-1' ) ) : 
		dynamic_sidebar( 'faq-1' ); 
    endif; 
?>
  <?php
  
	if( isset($theme_options['faq-display-order']) && $theme_options['faq-display-order'] != ''  ) {
		if( $theme_options['faq-display-order'] == 1 ) {
			$faq_record_order = 'ASC';
		} else {
			$faq_record_order = 'DESC';
		}
	}
	
	if( isset( $theme_options['faq-display-order-by'] ) && $theme_options['faq-display-order-by'] != '' ) {
		$faq_record_order_by = $theme_options['faq-display-order-by'];	
	} else {
		$faq_record_order_by = 'date';	
	}
	
	$paged_no = (get_query_var('paged')) ? get_query_var('paged') : 1;
	$args = array(
				'post_type' => 'manual_faq',
				'paged' => $paged_no,
				'posts_per_page' => (isset($theme_options['faq-noof-records-catper-page'])?$theme_options['faq-noof-records-catper-page']:'-1'),
				'order'    => $faq_record_order,
				'orderby'  => $faq_record_order_by,
				'tax_query' => array(
						array(
							'taxonomy' => 'manualfaqcategory',
							'field' => 'slug',
							'include_children' => true,
							'terms' => $term_slug
							)
						),
				
	);
	$wp_query_data = new WP_Query($args);
   
  if($wp_query_data->have_posts()) { 
  if ( have_posts() ) : ?>
  <div class="display-faq-section">
  
  	<div id="ajax-load-faq-container">
		<?php while($wp_query_data->have_posts()) :  $wp_query_data->the_post(); ?>
		<div class="collapsible-panels theme-faq-cat-pg faq-catpg-<?php echo esc_attr($post->ID); ?>" id="<?php echo esc_attr($post->ID); ?>">
		  <h5 class="title-faq-cat"><a href="#"><?php echo esc_html(get_the_title()); ?></a></h5>
		  <span class="faq-postlink" onclick="prompt('<?php echo esc_html__( 'Press Ctrl + C, then Enter to copy to clipboard', 'manual' ) ?>','<?php echo get_permalink().'#'.$post->ID ?>')"><?php echo esc_html__( '#', 'manual' ) ?></span>
		</div>
		<div class="entry-content clearfix entry-content-<?php echo esc_attr($post->ID); ?> entry-content-faq-all display-none">
			<?php the_content(); ?>
			<?php edit_post_link( esc_html__( 'Edit', 'manual' ), '<p class="post-edit-link" style="text-align:right"><i class="fa fa-edit"></i> ', '</p>', $post->ID ); ?>
			<?php if( $theme_options['faq-display-social-share'] == true ) manual_social_share(get_permalink()); ?>
	   </div>
	   <?php endwhile; ?>
   </div>
    <?php 
		// Previous/next page navigation.
		$total_pages = $wp_query_data->max_num_pages;
		$current_page = max(1, get_query_var('paged'));
		if ($total_pages > 1) {
			echo '<input id="faq_load_more_total_page" type="text" hidden value="'.$total_pages.'">
			      <input id="faq_load_more_current_page" type="text" hidden value="'.$current_page.'">
				  <input id="faq_load_more_slug_name" type="text" hidden value="'.$term_slug.'">';
				  
			echo '<nav class="navigation pagination"><div class="nav-links">
				  <a class="faq_ajax_load_prev page-numbers cursor-pointer" rel="1">&lt;</a>
				  <a id="faq_load_more_current_pg_no" class="page-numbers">'.$current_page.'</a>
				  <a class="faq_ajax_load_next page-numbers cursor-pointer" rel="2">&gt;</a>	
				  </div></nav>';	  
		}
		wp_reset_postdata();
		?>
  </div>
  <?php 
	// If no content, include the "No posts found" template.
	else :
		 esc_html_e( 'Sorry, no records were found', 'manual' );
	endif;
  }
?>
  <div class="clearfix"></div>
</div>

<?php 
	}
}
if( $sidebar_status == false && $sidebar_position == 'right' ) get_template_part('sidebar', 'faq');
?>
</div>
</div>
<?php 
get_footer(); 
?>